--------------------------------------------------------------------------------
--	This is TB2 startup script.
--	Keep it in max's Scripts/Startup
--------------------------------------------------------------------------------


--------------------------------------------------------------------------------
--	Script file guard
--	Examine its value to see how many times the script was run.
--------------------------------------------------------------------------------


if (guardTB2Startup == undefined) then
(
	global guardTB2Startup = -1
)

if (guardTB2Startup <= 0) then
(

	global gINIFile			= (getDir #maxroot) + "gamepacks\\bat\\BATFORMAX.ini"
	global gTB2ScriptsDir
	
	
	if gINIFile != undefined then
	
--*****CP must point this to the correct ini file if possible so this function returns the correct directory	
	(
		gTB2ScriptsDir	= (getdir #maxroot) + (getINISetting gINIFile "Configuration" "TB2Scripts")
	)
	
	if (gTB2ScriptsDir == undefined or gTB2ScriptsDir == "") then
	(
		gTB2ScriptsDir	= (getDir #scripts) + "\\"
	)
	
	--macros.load ((getDir #maxroot) + "ui\\macroscripts")
)

guardTB2Startup += 1

--------------------------------------------------------------------------------
--	Macro:	help macro																			
--------------------------------------------------------------------------------

--CP macroScript BATHelp
--CP	category:"BAT"
--CP	toolTip:"B.A.T. Help"
--CP (
--CP	GetHelp()
--CP )


--------------------------------------------------------------------------------
--	Function:	FnTB2FileIn 
--------------------------------------------------------------------------------
fn FnTB2FileInOnce fileName guard =
(
	if guard == undefined then
	(
		if fileName != undefined then
		(
			local filePath = gTB2ScriptsDir + fileName 
			
			if (doesFileExist filePath) then
			(			
				FileIn filePath
			)
		)
	)
	
	return ok
)

--------------------------------------------------------------------------------
--	Load the rest of the TB2 scripts
--------------------------------------------------------------------------------

if (guardTB2Startup == 0) then
(
	local initScript
	
	if gINIFile != undefined then
	(
		initScript = (getINISetting gINIFile "Configuration" "TB2InitScript")
	)
	
	if initScript == undefined then
	(
		initScript = "CPTB2Main.ms"
	)
	
	FnTB2FileInOnce initScript undefined
)