--------------------------------------------------------------------------------
--	Script file guard
--	Examine its value to see how many times the script was run.
--------------------------------------------------------------------------------
if (guardTB2MainUI == undefined) then
(
	global guardTB2MainUI = 0
)	

guardTB2MainUI += 1

--------------------------------------------------------------------------------
--	Make sure TB2 starup was executed first.
--------------------------------------------------------------------------------
if (guardTB2Startup == undefined) then
(
	global guardTB2Startup = 0
	FileIn ((getDir #startupScripts) + "\\TB2Startup.ms")
)

-----------------------------------------------------------------------------------------
-- Script library includes
-----------------------------------------------------------------------------------------
FnTB2FileInOnce "ScriptUtils.ms"		guardScriptUtils
FnTB2FileInOnce "BuildingMill.ms"	guardBuildingMill
FnTB2FileInOnce "CameraRig.ms"		guardCameraRig

-----------------------------------------------------------------------------------------
-- Export rollout
-----------------------------------------------------------------------------------------
rollout tb2RolloutExport "Export" width:162 height:84
(
	button btnExport "Export" pos:[12,6] width:138 height:24 toolTip:"Export current model"
	dropDownList ddlExportQuality "Quality" pos:[12,36] width:138 height:40 enabled:true items:#("Draft", "Low", "Medium", "High")
	
	on tb2RolloutExport open do
	(
		ddlExportQuality.selection = gAALevel + 1
	)
	
	----------------------------------------------------------------------------------------------------
	-- Event:	Export button pressed 
	----------------------------------------------------------------------------------------------------

	on btnExport pressed do
	(
		local bExport = checkForSave()
		
		if (bExport and (gAALevel < 3)) then 
		(
			local quality = "" 
			
			case gAALevel of
			(
				0:	quality = "draft"
				1:	quality = "low"
				2:	quality = "medium"
			)
	
			bExport = queryBox ("You are sure you want to export " + quality + " quality model?")
		)
		
		if bExport then
		(
			FnExportAllZoomsAndRotations gDestPath
		)
	)
	on ddlExportQuality selected sel do
	(
		gAALevel = ddlExportQuality.selection - 1
	)
)

-----------------------------------------------------------------------------------------
-- Parameters rollout
-----------------------------------------------------------------------------------------
rollout tb2RolloutParameters "Parameters" width:162 height:330
(
	-- UI elements
	checkbutton btnGeom "Hi Res Geo" pos:[30,6] width:102 height:18 enabled:true toolTip:"Hi-res Geometry On/Off"
	checkbutton btnLOD3 "LOD3" pos:[60,24] width:72 height:18 enabled:true toolTip:"LOD3 On/Off"
	checkbutton btnLOD4 "LOD4" pos:[60,42] width:72 height:18 enabled:true toolTip:"LOD4 On/Off"
	checkbutton btnLOD5 "LOD5" pos:[60,60] width:72 height:18 enabled:true toolTip:"LOD5 On/Off"
	checkbutton btnLODAll "All" pos:[30,24] width:30 height:54
	
	radiobuttons radioModelType "" pos:[12,126] width:76 height:32 labels:#("Building", "Foundation") columns:1
	button btnFixXRef "Reset Lights & Cameras" pos:[12,306] width:138 height:18
	spinner spnWindowOpacity "Global Intensity" pos:[24,186] width:120 height:16 range:[0,1,1] scale:0.1
	GroupBox grpNightWindows "Night Windows" pos:[6,168] width:150 height:132
	dropdownList ddlWindowSets "" pos:[12,210] width:138 height:21 items:(filterstring (GetNightWindowSets()) ";")
	button btnRefitLods "Re-fit LOD's" pos:[30,84] width:102 height:18
	GroupBox grpModelType "Model Type" pos:[6,108] width:150 height:54
	groupBox grp3 "Selection" pos:[12,234] width:138 height:60
	checkbox chk1 "Checkbox" pos:[24,252] width:0 height:0
	checkbox chkNightWindow "Enabled" pos:[24,252] width:120 height:18 triState:2
	spinner spnSelIntensity "Intensity" pos:[30,270] width:84 height:16 range:[0,1,1] indeterminate:true
	
	local kUPKeyNightWindow				=	"NightWindow"
	local kUPKeyNightWindowIntensity	=	"NightWindowBrightness"	

	----------------------------------------------------------------------------------------------------
	-- Function:	UpdateGlobalWindowParams 
	----------------------------------------------------------------------------------------------------

	fn UpdateGlobalWindowParams = 
	(
		local globalIntensity	= GetWindowOpacity true
		
		spnWindowOpacity.value 	= globalIntensity
		
		local windowSet = GetWindowSet()
		
		if (windowSet  != undefined) then
		(
			local idx = findItem ddlWindowSets.items windowSet
			
			if (idx > 0) then
			(
				ddlWindowSets.selection = idx
			)
		)
	)
	
	----------------------------------------------------------------------------------------------------
	-- Function:	UpdateModelType 
	----------------------------------------------------------------------------------------------------

	fn UpdateModelType = 
	(
		local typeStr = (GetModelType() as string)
		radioModelType.state = findItem kLegalBuildingTypes typeStr
		UpdateGlobalWindowParams()
	)
	
	----------------------------------------------------------------------------------------------------
	-- Function:	UpdateWindowParams 
	----------------------------------------------------------------------------------------------------

	fn UpdateWindowParams = 
	(
		if selection.count == 0 then
		(
			chkNightWindow.enabled = false
			spnSelIntensity.enabled = false
			return ok
		)
		
		local globalIntensity	= GetWindowOpacity true	
		local enabledCount 		= 0
		local disabledCount 	= 0
		local bCommonIntensity	= true
		local fCommonIntensity
		local node
		
		for node in selection do
		(
			if (superClassOf node) != GeometryClass then
			(
				continue
			)
			
			local nightWindowEnabled = getUserProp node kUPKeyNightWindow
			
			if nightWindowEnabled == undefined then
			(
				disabledCount  += 1
			)
			else if nightWindowEnabled then
			(
				enabledCount += 1
				
				if fCommonIntensity == undefined then
				(
					local intensity = getUserProp node kUPKeyNightWindowIntensity
					if intensity == undefined then
					(
						fCommonIntensity = globalIntensity
					)
					else
					(
						fCommonIntensity = (intensity as float)
					)
				)
				
				if bCommonIntensity then
				(
					local intensity = getUserProp node kUPKeyNightWindowIntensity
					
					if intensity == undefined then
					(
						if fCommonIntensity  != globalIntensity then
						(
							bCommonIntensity = false
						)
					)
					else if fCommonIntensity  != (intensity as float) then
					(
						bCommonIntensity = false
					)
				)
			)
			else
			(
				disabledCount  += 1
			)
		)
		
		if disabledCount == 0 and enabledCount == 0 then
		(
			chkNightWindow.enabled = false
			spnSelIntensity.enabled = false
			return ok
		)
		
		chkNightWindow.enabled = true

		--	Prior to max 5 spinner and checkbox controls did not have indetermined state.
		--	Therefore, we show indetermined checkbox as disabled, and indtermined
		--	intensity is set to gloabal intensity.

		
		if disabledCount == 0 then
		(
			chkNightWindow.checked = (enabledCount > 0)
		)
		else
		(
			chkNightWindow.checked = false
		)	
		
		spnSelIntensity.enabled = chkNightWindow.checked
	
		--	Set common intensity value
		
		if bCommonIntensity then
		(
			if fCommonIntensity  == undefined then
			(
				fCommonIntensity  = globalIntensity
			)
		)
		else
		(
		 	fCommonIntensity  = globalIntensity
		)
		
		spnSelIntensity.value = fCommonIntensity  

		
		return ok
	)
	----------------------------------------------------------------------------------------------------
	-- Function:	UpdateLodButtons 
	----------------------------------------------------------------------------------------------------
	
	fn UpdateLodButtons = 
	(
		local vis5 = false
		local vis4 = false
		local vis3 = false
		local curNode
		
		curNode = $LOD3
		if (curNode != undefined) do 
		(
			vis3 = (curNode.isHidden != true)
		)
		
		curNode = $LOD4
		if (curNode != undefined) do 
		(
			vis4 = (curNode.isHidden != true)
		)
		
		curNode = $LOD5
		if (curNode != undefined) do 
		(
			vis5 = (curNode.isHidden != true)
		)
		
		btnLOD3.checked 	= vis3
		btnLOD4.checked 	= vis4
		btnLOD5.checked 	= vis5
		btnLODAll.checked = vis5 or vis4 or vis3
	)
	
	----------------------------------------------------------------------------------------------------
	-- Function:	UpdateLodButtons 
	----------------------------------------------------------------------------------------------------
	
	fn ShowLOD level show = 
	(
		local lod = FnFindLOD level 
		if lod != undefined then
		(
			if show then
				unhide lod 
			else
				hide lod 
		)
	)

	on tb2RolloutParameters open do
	(
		UpdateModelType()
		UpdateLodButtons()
		UpdateWindowParams()
		UpdateGlobalWindowParams()
		
		callbacks.addscript #filePostOpen 			"tb2RolloutParameters.UpdateModelType()" 	id:#tb2RolloutParameters
		callbacks.addscript #selectionSetChanged	"tb2RolloutParameters.UpdateWindowParams()" id:#tb2RolloutParameters
	)
	on tb2RolloutParameters close do
	(
		callbacks.removescripts id:#tb2RolloutParameters
	)
	on btnGeom changed state do
	(
		-- apply new state to everything
		if (state) then 
		(
			unhide $geometry
			unhide $shapes
		)
		else 
		(
			hide $geometry
			hide $shapes
		)
			
		-- now go fix  the state of the LODs
		if (btnLOD3.state != state) do 
		(
			ShowLOD 3 state
		)
		
		if (btnLOD4.state != state) do 
		(
			ShowLOD 4 state
		)
		
		if (btnLOD5.state != state) do 
		(
			ShowLOD 5 state
		)
		
	)
	on btnLOD3 changed state do
	(
		ShowLOD 3 state
		UpdateLodButtons()
	)
	on btnLOD4 changed state do
	(
		ShowLOD 4 state
		UpdateLodButtons()
	)
	on btnLOD5 changed state do
	(
		ShowLOD 5 state
		UpdateLodButtons()
	)
	on btnLODAll changed state do
	(
		local lods = $LOD*
		if lods != undefined and lods.count > 0 then
		(
			if state then
				unhide lods 
			else
				hide lods 		
		)
		UpdateLodButtons()
	)
	on radioModelType changed newState do
	(
		SetModelType kLegalBuildingTypes[newState]
	)
	on btnFixXRef pressed do
	(
		setWaitCursor()
		local fixResult = gCameraRig.AutoCheckAndFixXRef()
		setArrowCursor()
		case fixResult of
		(
			0:		InfoBox "Camera and lights set successfully."
			1: 	messageBox "Camera and lights have been automatically set using the best option availible.\nFor better results it may be necessary to custom create a camera and lighting rig that is unique to this model."
			(-1):	messageBox "Unknown Camera and Lights Rig error!"
			(-2): messageBox "Camera and Lights Rig file not found!"
		)
	)
	on spnWindowOpacity changed val do
	(
		SetWindowOpacity spnWindowOpacity.value
	)
	on ddlWindowSets selected sel do
	(
		SetWindowSet ddlWindowSets.selected
	)
	on btnRefitLods pressed do
	(
		local doRefit = true
		
		if geometry.count == 0 then
		(
			messageBox "The scene is empty. No LOD will be created."
			doRefit = false
		)
		else if $LOD*.count > 0 then
		(
			doRefit = queryBox "The scene already conatins LODs. They will be destroyed in the process.\nAre you sure you want to continue?"
		)
		
		if doRefit then 
		(
			delete $LOD*
			FnCreateLOD_3_4_5()
		)
	)
	on chkNightWindow changed state do
	(
		local node
		
		for node in selection do
		(
			if (superClassOf node) == GeometryClass then
			(
				setUserProp node kUPKeyNightWindow state
			)
		)
		
		spnSelIntensity.enabled = state
	)
	on spnSelIntensity changed val do
	(
		local node
		
		for node in selection do
		(
			if (superClassOf node) == GeometryClass then
			(
				setUserProp node kUPKeyNightWindowIntensity val
			)
		)
	)
)

-----------------------------------------------------------------------------------------
-- Preview rollout
-----------------------------------------------------------------------------------------
rollout tb2RolloutPreview "Preview" width:162 height:366
(
	-- local vairables
	local radioXLate 	= #(2, 3, 1, 4) -- maps radio button indicies to rotation #s
	local rotXLate 	= #(3, 1, 2, 4) -- maps rotation numbers to radio button indicies
	local DefState 	= #(146, 292) -- sets teh zoom of the Z5camera
	
	GroupBox grpNavigation "View Navigation" pos:[6,6] width:150 height:222
	-- UI elements
	radiobuttons rdoRotation "<- Rotation ->" pos:[48,24] width:68 height:46 labels:#("E", "N", "S", "W") default:3 columns:2
	
	slider sldZoom "Zoom" pos:[32,96] width:32 height:99 enabled:true range:[0,4,4] type:#integer orient:#vertical ticks:5
	button btnRotLeft "<--" pos:[30,72] width:48 height:18 toolTip:"Rotate Left"
	button btnRotRight "-->" pos:[84,72] width:48 height:18 toolTip:"Rotate Right"
	label lblZ1 "1" pos:[72,175] width:11 height:13
	label lblZ2 "2" pos:[72,161] width:11 height:13
	label lblZ3 "3" pos:[72,147] width:11 height:13
	label lblZ5 "5" pos:[72,120] width:11 height:13
	label lblZ4 "4" pos:[72,133] width:11 height:13
	button btnZoomOut "Out" pos:[88,174] width:44 height:18 toolTip:"Zoom Out"
	button btnZoomIn "In" pos:[90,120] width:42 height:18 toolTip:"Zoom In"
	button btnThumbnailView "Thumbnail View" pos:[18,204] width:126 height:18
	
	GroupBox grpPreview "Preview" pos:[6,234] width:150 height:166
	radiobuttons SdHd "select for Zoom5:" pos:[15,252] labels:#("SDoutput", "HDoutput") default:1 columns:2
	dropDownList ddlQuality "Quality" pos:[18,292] width:126 height:40 enabled:true items:#("Draft", "Low", "Medium", "High")
	button btnPreview "Day" pos:[18,340] width:126 height:18 toolTip:""
	button btnNightPreview "Day & Night" pos:[18,358] width:126 height:18
	button btnThumbnailPreview "Thumbnails" pos:[18,376] width:126 height:18
	
	

	
	
	on tb2RolloutPreview open do
	(
		ddlQuality.selection = gPreviewAALevel + 1
	)
	
	on rdoRotation changed stat do
	(
		gCameraRig.SetCam (sldZoom.value+1) radioXLate[stat] updateViewport:true 
	)
	on sldZoom changed val do
	(
		gCameraRig.SetCam (val+1) radioXLate[rdoRotation.state] updateViewport:true
	)
	on btnRotLeft pressed do
	(
		local rotVal = 1
		
		if (gCameraRig.curRot != undefined) then
		(
			rotVal = (mod gCameraRig.curRot 4)+1
		)
		
		if (gCameraRig.SetCam (sldZoom.value+1) rotVal updateViewport:true) do 
		(
			rdoRotation.state = rotXLate[rotVal]
		)
	)
	on btnRotRight pressed do
	(
		local rotVal = 1
		
		if (gCameraRig.curRot != undefined) then
		(
			rotVal = (mod (gCameraRig.curRot+2) 4)+1
		)
			
		if (gCameraRig.SetCam (sldZoom.value+1) rotVal updateViewport:true) do 
		(
			rdoRotation.state = rotXLate[rotVal]
		)
	)
	on btnZoomOut pressed do
	(
		if (sldZoom.value > 0) do 
		(
			sldZoom.value -= 1
			gCameraRig.SetCam (sldZoom.value+1) radioXLate[rdoRotation.state] updateViewport:true
		)
	)
	on btnZoomIn pressed do
	(
		if (sldZoom.value < 4) do 
		(
			sldZoom.value += 1
			gCameraRig.SetCam (sldZoom.value+1) radioXLate[rdoRotation.state] updateViewport:true
		)
	)
	
	on SdHd changed stat do
	(
		sfhd = DefState[stat]
			if sfhd == 146 then
			filein "CameraRig.ms"
			else
			filein "SFCameraRigHD.ms"
	)
		
	on btnPreview pressed do
	(
		FnDoPreviewRender #day (sldZoom.value+1) radioXLate[rdoRotation.state]
		--UpdateLodButtons()
	)
	on btnNightPreview pressed do
	(
		FnDoPreviewRender #night (sldZoom.value+1) radioXLate[rdoRotation.state]
		--UpdateLodButtons()
	)
	on btnThumbnailPreview pressed do
	(
		FnDoThumbnailPreview()
	)
	on btnThumbnailView pressed do
	(	
		if (gCameraRig.SetThumbnailCam refresh:false) then
		(
			viewport.setCamera gCameraRig.curCam 
		)
	)
	
	on ddlQuality selected sel do
	(
		gPreviewAALevel = ddlQuality.selection - 1
	)
)

---------------------------------------------------------------------------------------
--	Function:	OpenTB2MainUI														
---------------------------------------------------------------------------------------
fn OpenTB2MainUI =
(
	addRollout tb2RolloutExport 		rolledUp:false
	addRollout tb2RolloutParameters 	rolledUp:true
	addRollout tb2RolloutPreview 		rolledUp:true
)

---------------------------------------------------------------------------------------
--	Function:	CloseTB2MainUI														
---------------------------------------------------------------------------------------
fn CloseTB2MainUI =
(
	removeRollout tb2RolloutExport
	removeRollout tb2RolloutParameters
	removeRollout tb2RolloutPreview
)

