--------------------------------------------------------------------------------
--	Script file guard															
--	Examine its value to see how many times the script was run.	
--------------------------------------------------------------------------------
if (guardTB2Main == undefined) then
(
	global guardTB2Main = 0
)	

guardTB2Main += 1

--------------------------------------------------------------------------------
--	Make sure TB2 starup was executed first.							
--------------------------------------------------------------------------------
if (guardTB2Startup == undefined) then
(
	global guardTB2Startup = 0
	FileIn ((getDir #startupScripts) + "\\TB2Startup.ms")
)

-----------------------------------------------------------------------------------------
--	Glogal variables used throughout all scripts						
-----------------------------------------------------------------------------------------

global gCurrentPluginVers 		= 4211
global gErrorNotify				= true
global gAALevel					= 3
global gPreviewAALevel			= 1
global gAADiameter				= 1.5
global gAABlur						= 0.0
global gWindowOpacityRelMin	= 0.3
global gWindowOpacityRelMax	= 0.5
global gThumbnailBgColor		= white
global gCurRendererID

global gDestPath
global gExportExt
global gCamLightsPath
global gCamLightsFolder

global gTB2SystemInit

-----------------------------------------------------------------------------------------
--	System initialization													
-----------------------------------------------------------------------------------------


---------------------------------------------------
--	Function: 	FnInitErrorNotify							
---------------------------------------------------
fn	FnInitErrorNotify	errorMsg errorCode =	
(
	errorMsg += "\n\n[error # " + (errorCode as string) + "]"
	
	MessageBox errorMsg
	
	return errorCode
)


---------------------------------------------------
--	Function: 	FnTB2SystemInit							
---------------------------------------------------
fn	FnTB2SystemInit	=	
(
	local errorMsg	
	
	try
	(
		if gTB2SystemInit != undefined then
		(
			return gTB2SystemInit
		)

		--	Check plugin version

		if (TB2PluginVers == undefined) then
		(		
			errorMsg = "The SimCity plugin 'Rendlx.dlx' could not be found or it failed to load."

			return FnInitErrorNotify errorMsg -2
		)

		if (TB2PluginVers() != gCurrentPluginVers) then 
		(
			errorMsg  = "The SimCity plugin 'Rendlx.dlx' version does not match the scripts."
			errorMsg += "\n'Rendlx.dlx' version = " + (TB2PluginVers() as string)
			errorMsg += "\nScript version       = " + (gCurrentPluginVers as string)

			return FnInitErrorNotify errorMsg -3
		)

		--	Initialize plugins

		if (SC4PluginsInit == undefined) then
		(		
			errorMsg = "SC4 Plugins initialization function is undefined."

			return FnInitErrorNotify errorMsg -4
		)

		gTB2SystemInit		= SC4PluginsInit()

		if gTB2SystemInit != 0 then
		(
			errorMsg = "SC4 Plugins initialization function is undefined."

			return FnInitErrorNotify errorMsg gTB2SystemInit
		)
		else
		(
			gTB2SystemInit	= -100 --	Reset for the rmaining initializations
		)

		--	Get renderer ID
		
		gCurRendererID		= GetCurRendererID()
		
		--	Get export directory

		if gINIFile != undefined then
		(
			gDestPath	= (getINISetting gINIFile "Configuration" "DestPath")
		)

		if (gDestPath == undefined or gDestPath == "") then
		(
			gDestPath = GetSC4ExportDir()
			
			--	TO DO: temporary fix - remove after version 1035 
			if (gCurrentPluginVers == 1035) then
			(
				local pos = findString gDestPath "Models"
				
				if (pos != undefined) then			
				(
					gDestPath = replace gDestPath pos 6 "Plugins"
				)
			)
		)

		if (gDestPath == undefined or gDestPath == "") then
		(
			errorMsg = "Undefined export directory."

			return FnInitErrorNotify errorMsg -5
		)
		
		--	Get export extension

		if gINIFile != undefined then
		(
			gExportExt	= (getINISetting gINIFile "Configuration" "ExportExt")
		)

		if (gExportExt == undefined or gExportExt == "") then
		(
			gExportExt = GetSC4ExportExt()
		)

		if (gExportExt == undefined or gExportExt == "") then
		(
			gExportExt = ".SC4Model"
		)
		
		--	Find Cam & Lights Rig
		
		if gINIFile != undefined then
		(
			local relRigPath 		= (getINISetting gINIFile "Configuration" "CamerasAndLights")
			local relRigFolder 	= (getINISetting gINIFile "Configuration" "CamerasAndLightsFolder")
			
			if (relRigPath != undefined and relRigPath.count > 0) then
			(
				gCamLightsPath	= (getDir #maxroot) + relRigPath
			)
			
			if (relRigFolder != undefined and relRigFolder.count > 0) then
			(
				gCamLightsFolder	= (getDir #maxroot) + relRigFolder
			)
		)
		
		if (gCamLightsPath == undefined or gCamLightsPath == "") then
		(
			gCamLightsPath	= (getDir #maxroot) + "gamepacks\\BAT\\scenes\\CamLightRigs\\TB2_CameraLightRig.gmax"
		)
		
		if (gCamLightsFolder == undefined or gCamLightsFolder == "") then
		(
			gCamLightsFolder	= (getDir #maxroot) + "gamepacks\\BAT\\scenes\\CamLightRigs\\"
		)
		
		if (not (doesFileExist gCamLightsPath)) then
		(
			errorMsg 		= "Cameras and Light file \n\"" + gCamLightsPath + "\"\ncould not be found"
			gCamLightsPath = ""

			return FnInitErrorNotify errorMsg -6
		)
		
		--	Find AA level
		
		if gINIFile != undefined then
		(
			local aaLev = (getINISetting gINIFile "Configuration" "AALevel")
			
			if (aaLev == undefined or aaLev == "") then
			(
				gAALevel = aaLev as integer
			)
			
		)
		

		gTB2SystemInit = -1	--	-1 signifies successful initialization	
	)
	catch
	(
		errorMsg = "Unknown SC4 initialization error!"

		return FnInitErrorNotify errorMsg -100
	)
	
	return gTB2SystemInit
)

-----------------------------------------------------------------------------------------
-- Run initialization function											
-----------------------------------------------------------------------------------------
gTB2SystemInit = FnTB2SystemInit()


-----------------------------------------------------------------------------------------
-- Script library includes													
-----------------------------------------------------------------------------------------
FnTB2FileInOnce "ScriptUtils.ms"		guardScriptUtils
FnTB2FileInOnce "BuildingMill.ms"	guardBuildingMill
FnTB2FileInOnce "TB2MainUI.ms"		guardTB2MainUI

---------------------------------------------------
--	Function: 	FnTB2PostloadSystemCheck							
---------------------------------------------------
fn	FnTB2PostloadSystemCheck	=
(
	if (gTB2SystemInit == 0) then
	(
		return 0
	)


	if (gTB2SystemInit != -1) then
	(
		return gTB2SystemInit
	)
	
	
	if guardBuildingMill == undefined then
	(
		errorMsg = "Failed to load \"BuildingMill.ms\""

		return FnInitErrorNotify errorMsg -102
	)
	
	if guardCameraRig == undefined then
	(
		errorMsg = "Failed to load \"CameraRig.ms\""

		return FnInitErrorNotify errorMsg -103
	)
	
	if guardFileUtils == undefined then
	(
		errorMsg = "Failed to load \"FileUtils.ms\""

		return FnInitErrorNotify errorMsg -104
	)
	
	
	if guardModelNames == undefined then
	(
		errorMsg = "Failed to load \"ModelNames.ms\""

		return FnInitErrorNotify errorMsg -102
	)
	
	if guardScriptUtils == undefined then
	(
		errorMsg = "Failed to load \"ScriptUtils.ms\""

		return FnInitErrorNotify errorMsg -101
	)
	
	if guardStringUtils == undefined then
	(
		errorMsg = "Failed to load \"StringUtils.ms\""

		return FnInitErrorNotify errorMsg -102
	)
	
	if guardTB2MainUI == undefined then
	(
		errorMsg = "Failed to load \"TB2MainUI.ms\""

		return FnInitErrorNotify errorMsg -102
	)
	
	return 0
)

-----------------------------------------------------------------------------------------
-- Run initialization function											
-----------------------------------------------------------------------------------------
gTB2SystemInit = FnTB2PostloadSystemCheck()



